<?php

// -------------------------------
// Cloudflare Radar API (v4) – FIXED AUTH
// -------------------------------

$TOKEN = "-2rtixH2V4Yrzfb8y7Zk3sbjn0uz7zIWl-8mZhvk";

$log_file = __DIR__ . "/logs/radar_requests.log";
if (!file_exists(dirname($log_file))) mkdir(dirname($log_file), 0777, true);

function radar_get($endpoint, $params = []) {
    global $TOKEN, $log_file;

    $url = "https://api.cloudflare.com/client/v4/radar/" . $endpoint;

    if (!empty($params)) {
        $url .= "?" . http_build_query($params);
    }

    $headers = [
        "Authorization: Bearer " . $TOKEN,
        "Content-Type: application/json"
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_SSL_VERIFYPEER => true
    ]);

    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $errno = curl_errno($ch);
    $error = curl_error($ch);
    curl_close($ch);

    // log
    $log = [
        "time" => date("c"),
        "endpoint" => $endpoint,
        "url" => $url,
        "headers" => $headers,
        "http_code" => $info["http_code"],
        "curl_error" => $error,
        "response_sample" => substr($response, 0, 700)
    ];
    file_put_contents($log_file, json_encode($log, JSON_UNESCAPED_SLASHES) . "\n", FILE_APPEND);

    return json_decode($response, true);
}


// ------------------------------------------------------
// VALID ENDPOINTS (all corrected and authenticated)
// ------------------------------------------------------

$device_summary = radar_get("http/summary/device_type", [
    "dateRange" => "1d",
    "format" => "json"
]);

$ip_version = radar_get("http/summary/ip_version", [
    "dateRange" => "1d",
    "format" => "json"
]);

$top_as = radar_get("http/top/ases", [
    "dateRange" => "1d",
    "format" => "json",
    "limit" => 5,
    "geoId" => 130758
]);



$netflows = radar_get("netflows/timeseries_groups", [
    "dimension" => "adm1",
    "dateRange" => "1d",
    "aggInterval" => "1h",
    "format" => "json"
]);

$dns_ts = radar_get("dns/timeseries", [
    "dateRange" => "1d",
    "aggInterval" => "1h",
    "format" => "json"
]);

$layer7 = radar_get("attacks/layer7/timeseries", [
    "dateRange" => "1d",
    "aggInterval" => "1h",
    "format" => "json"
]);


// ------------------------------------------------------
// Output JSON
// ------------------------------------------------------

header("Content-Type: application/json; charset=utf-8");

echo json_encode([
    "device_type_summary" => $device_summary,
    "ip_version" => $ip_version,
    "top_as" => $top_as,
    "netflows_adm1" => $netflows,
    "dns_timeseries" => $dns_ts,
    "layer7_attacks" => $layer7
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
